<?php if (!defined('VB_ENTRY')) die('Access denied.');
/*======================================================*\
|| ############################################### ||
|| # ----------------vBSmart Team - vBulletin 4.0.1Version ------------------------- # ||
|| # Copyright 2000-2010 vBulletin Solutions Inc. All Rights Reserved. ||
|| #      This file may not be redistributed in whole or significant part    . # ||
|| ############################################### ||
\*======================================================*/

require_once DIR . '/includes/class_taggablecontent.php' ;
/**
* Handle thread specific logic
*
*	Internal class, should not be directly referenced
* use vB_Taggable_Content_Item::create to get instances
*	see vB_Taggable_Content_Item for method documentation
*/
class vBCms_TaggableContent_Content extends vB_Taggable_Content_Item
{
	//nodeid is important

	private $nodeid = false;

	protected function load_content_info()
	{
		$type_instance = vB_Types::instance();
		$class = $type_instance->getContentTypeClass($this->contenttypeid);
		$package = $type_instance->getContentTypePackage($this->contenttypeid);

		//this forces some of the fields we access to be loaded.
		$contentinfo = vBCms_Content::create($package, $class);

		//we have a contenttype and content id, but we need the nodeid.
		if ($record = vB::$vbulletin->db->query_first("SELECT nodeid FROM " . TABLE_PREFIX .
			"cms_node WHERE contenttypeid = " . $this->contenttypeid . " AND contentid = " .
			$this->contentid))
		{
			$item = vB_Item_Content::create($package, $class, $this->nodeid = $record['nodeid']);
			$item->requireInfo($contentinfo->getViewInfoFlags(vB_Content::VIEW_PREVIEW));
			$contentinfo->setContentItem($item);

			return $contentinfo;
		}
		return false;
	}

	public function can_moderate_tag()
	{
		return $this->can_add_tag();
	}

	public function can_add_tag()
	{
		if (! isset(vB::$vbulletin->userinfo['permissions']['cms']))
		{
			vBCMS_Permissions::getUserPerms();
		}
		//until we have better developed permissions, limit tagging
		//to item editors only.
		return vBCMS_Permissions::canEdit($this->fetch_content_info()->getNodeId());
	}

	public function is_owned_by_current_user()
	{
		$contentinfo = $this->fetch_content_info();
		return ($contentinfo->getUserId() == $this->registry->userinfo['userid']);
	}

	public function fetch_content_type_diplay()
	{
		return vB_Types::instance()->getContentTypeTitle($this->contenttypeid);
	}

	public function is_cloud_cachable()
	{
		return true;
	}

	public function fetch_tag_cloud_query_bits()
	{
		$join['cms_node'] = "JOIN " . TABLE_PREFIX . "cms_node AS cms_node ON
			tagcontent.contenttypeid = cms_node.contenttypeid AND tagcontent.contentid = cms_node.contentid
		";
		$where[] = 'cms_node.publishdate < ' . TIMENOW;
		return array('join' => $join, 'where' => $where);
	}

	public function get_title()
	{
		//probably shouldn't leave this as the default, but provides
		//shim code for existing implementations
		return $this->fetch_content_info()->getTitle();
	}

	public function fetch_return_url()
	{
		return $this->fetch_content_info()->getPageUrl();
	}

	public function fetch_page_nav()
	{
		return array();
	}
}

/*======================================================================*\
|| ####################################################################
|| # Downloaded: 17:48, Tue Jan 12th 2010
|| # CVS: $RCSfile$ - $Revision: 27657 $
|| ####################################################################
\*======================================================================*/